/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.OutputDocument;

public final class FormFields
extends AbstractCollection<FormField> {
    private final LinkedHashMap<String, FormField> map = new LinkedHashMap();
    private final ArrayList<FormControl> formControls = new ArrayList();
    private Column[] columns = null;

    public FormFields(Collection<FormControl> formControls) {
        for (FormControl formControl : formControls) {
            if (formControl.getName() == null || formControl.getName().length() == 0) continue;
            formControl.addToFormFields(this);
            this.formControls.add(formControl);
        }
    }

    public int getCount() {
        return this.map.size();
    }

    @Override
    public int size() {
        return this.getCount();
    }

    public FormField get(String fieldName) {
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            fieldName = fieldName.toLowerCase();
        }
        return this.map.get(fieldName);
    }

    @Override
    public Iterator<FormField> iterator() {
        return this.map.values().iterator();
    }

    public List<String> getValues(String fieldName) {
        FormField formField = this.get(fieldName);
        return formField == null ? null : formField.getValues();
    }

    public Map<String, String[]> getDataSet() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>((int)((double)this.getCount() / 0.7));
        for (FormField formField : this) {
            List<String> values = formField.getValues();
            if (values.isEmpty()) continue;
            map.put(formField.getName(), values.toArray(new String[values.size()]));
        }
        return map;
    }

    public void clearValues() {
        for (FormControl formControl : this.formControls) {
            formControl.clearValues();
        }
    }

    public void setDataSet(Map<String, String[]> dataSet) {
        this.clearValues();
        if (this.map == null) {
            return;
        }
        for (Map.Entry<String, String[]> entry : dataSet.entrySet()) {
            String fieldName = entry.getKey();
            FormField formField = this.get(fieldName);
            if (formField == null) continue;
            formField.addValues(entry.getValue());
        }
    }

    public boolean setValue(String fieldName, String value) {
        FormField formField = this.get(fieldName);
        return formField == null ? false : formField.setValue(value);
    }

    public boolean addValue(String fieldName, String value) {
        FormField formField = this.get(fieldName);
        return formField == null ? false : formField.addValue(value);
    }

    public String[] getColumnLabels() {
        this.initColumns();
        String[] columnLabels = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            String fieldName = column.formField.getFirstFormControl().getName();
            columnLabels[i] = column.predefinedValue != null ? fieldName + '.' + column.predefinedValue : fieldName;
        }
        return columnLabels;
    }

    public String[] getColumnValues(Map<String, String[]> dataSet) {
        this.initColumns();
        String[] columnValues = new String[this.columns.length];
        if (Config.ColumnValueFalse != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].isBoolean) continue;
                columnValues[i] = Config.ColumnValueFalse;
            }
        }
        for (Map.Entry<String, String[]> entry : dataSet.entrySet()) {
            String fieldName = entry.getKey();
            FormField formField = this.get(fieldName);
            if (formField == null) continue;
            int columnIndex = formField.columnIndex;
            block2: for (String value : entry.getValue()) {
                for (int ci = columnIndex; ci < this.columns.length; ++ci) {
                    Column column = this.columns[ci];
                    if (column.formField != formField) continue block2;
                    if (column.predefinedValue != null) {
                        if (!column.predefinedValue.equals(value)) continue;
                        columnValues[ci] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (column.isBoolean) {
                        if (value == null) continue block2;
                        columnValues[ci] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (columnValues[ci] == null) {
                        columnValues[ci] = value;
                        continue block2;
                    }
                    columnValues[ci] = columnValues[ci] + Config.ColumnMultipleValueSeparator + value;
                    continue block2;
                }
            }
        }
        return columnValues;
    }

    public String[] getColumnValues() {
        return this.getColumnValues(this.getDataSet());
    }

    private void initColumns() {
        if (this.columns != null) {
            return;
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (FormField formField : this) {
            formField.columnIndex = columnList.size();
            if (!formField.allowsMultipleValues() || formField.getPredefinedValues().isEmpty()) {
                columnList.add(new Column(formField, formField.getPredefinedValues().size() == 1, null));
                continue;
            }
            for (String predefinedValue : formField.getPredefinedValues()) {
                columnList.add(new Column(formField, true, predefinedValue));
            }
            if (formField.getUserValueCount() <= 0) continue;
            columnList.add(new Column(formField, false, null));
        }
        this.columns = columnList.toArray(new Column[columnList.size()]);
    }

    public List<FormControl> getFormControls() {
        return this.formControls;
    }

    public void merge(FormFields formFields) {
        for (FormField formField : formFields) {
            String fieldName = formField.getName();
            FormField existingFormField = this.get(fieldName);
            if (existingFormField == null) {
                this.map.put(formField.getName(), formField);
                continue;
            }
            existingFormField.merge(formField);
        }
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        for (FormField formField : this) {
            sb.append(formField);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getDebugInfo();
    }

    void add(FormControl formControl) {
        this.add(formControl, formControl.getPredefinedValue());
    }

    void add(FormControl formControl, String predefinedValue) {
        this.add(formControl, predefinedValue, formControl.name);
    }

    void addName(FormControl formControl, String fieldName) {
        this.add(formControl, null, fieldName);
    }

    void add(FormControl formControl, String predefinedValue, String fieldName) {
        FormField formField;
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            fieldName = fieldName.toLowerCase();
        }
        if ((formField = this.map.get(fieldName)) == null) {
            formField = new FormField(fieldName);
            this.map.put(formField.getName(), formField);
        }
        formField.addFormControl(formControl, predefinedValue);
    }

    void replaceInOutputDocument(OutputDocument outputDocument) {
        for (FormControl formControl : this.formControls) {
            outputDocument.replace(formControl);
        }
    }

    private static class Column {
        public FormField formField;
        public boolean isBoolean;
        public String predefinedValue;

        public Column(FormField formField, boolean isBoolean, String predefinedValue) {
            this.formField = formField;
            this.isBoolean = isBoolean;
            this.predefinedValue = predefinedValue;
        }
    }
}

