/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Tag;

public class EndTagTypeGenericImplementation
extends EndTagType {
    private final String staticString;

    protected EndTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, boolean isServerTag, boolean isStatic) {
        super(description, startDelimiter, closingDelimiter, isServerTag);
        this.staticString = isStatic ? startDelimiter + closingDelimiter : null;
    }

    protected final boolean isStatic() {
        return this.staticString != null;
    }

    @Override
    public String getEndTagName(String startTagName) {
        return this.isStatic() ? this.getNamePrefix() : startTagName;
    }

    @Override
    public String generateHTML(String startTagName) {
        return this.isStatic() ? this.staticString : super.generateHTML(startTagName);
    }

    @Override
    protected Tag constructTagAt(Source source, int pos) {
        ParseText parseText = source.getParseText();
        int nameBegin = pos + "</".length();
        String name = null;
        int startDelimiterEnd = pos + this.getStartDelimiter().length();
        int end = -1;
        if (this.isStatic()) {
            name = this.getNamePrefix();
            if (!parseText.containsAt(this.getClosingDelimiter(), startDelimiterEnd)) {
                if (source.logger.isErrorEnabled()) {
                    source.logger.error(source.getRowColumnVector(pos).appendTo(new StringBuilder(200).append("EndTag of expected format ").append(this.staticString).append(" at ")).append(" not recognised as type '").append(this.getDescription()).append("' because it is missing the closing delimiter").toString());
                }
                return null;
            }
            end = startDelimiterEnd + this.getClosingDelimiter().length();
        } else {
            int nameEnd = source.getNameEnd(startDelimiterEnd);
            if (nameEnd == -1) {
                return null;
            }
            name = source.getName(nameBegin, nameEnd);
            int expectedClosingDelimiterPos = nameEnd;
            while (Segment.isWhiteSpace(parseText.charAt(expectedClosingDelimiterPos))) {
                ++expectedClosingDelimiterPos;
            }
            if (!parseText.containsAt(this.getClosingDelimiter(), expectedClosingDelimiterPos)) {
                if (source.logger.isErrorEnabled()) {
                    source.logger.error(source.getRowColumnVector(pos).appendTo(new StringBuilder(200).append("EndTag ").append(name).append(" at ")).append(" not recognised as type '").append(this.getDescription()).append("' because its name and closing delimiter are separated by characters other than white space").toString());
                }
                return null;
            }
            end = expectedClosingDelimiterPos + this.getClosingDelimiter().length();
        }
        return this.constructEndTag(source, pos, end, name);
    }
}

