/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.ansj.dic.DicReader;
import org.ansj.dic.impl.Jdbc2Stream;
import org.ansj.domain.AnsjItem;
import org.ansj.library.DATDictionary;
import org.nlpcn.commons.lang.util.FileFinder;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.ObjConver;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class MyStaticValue {
    public static final Log LOG;
    public static Boolean isNameRecognition;
    public static Boolean isNumRecognition;
    public static Boolean isQuantifierRecognition;
    public static Boolean isRealName;
    public static boolean isSkipUserDefine;
    public static final Map<String, String> ENV;

    public static BufferedReader getPersonReader() {
        return DicReader.getReader("person/person.dic");
    }

    public static BufferedReader getCompanReader() {
        return DicReader.getReader("company/company.data");
    }

    public static BufferedReader getNewWordReader() {
        return DicReader.getReader("newWord/new_word_freq.dic");
    }

    public static BufferedReader getArraysReader() {
        return DicReader.getReader("arrays.dic");
    }

    public static BufferedReader getNumberReader() {
        return DicReader.getReader("numberLibrary.dic");
    }

    public static BufferedReader getEnglishReader() {
        return DicReader.getReader("englishLibrary.dic");
    }

    public static BufferedReader getNatureMapReader() {
        return DicReader.getReader("nature/nature.map");
    }

    public static BufferedReader getNatureTableReader() {
        return DicReader.getReader("nature/nature.table");
    }

    public static BufferedReader getNatureClassSuffix() {
        return DicReader.getReader("nature_class_suffix.txt");
    }

    public static BufferedReader getPersonFreqReader() {
        return DicReader.getReader("person/name_freq.dic");
    }

    public static Map<String, int[][]> getPersonFreqMap() {
        Map<String, Object> map = new HashMap<String, int[][]>(0);
        try {
            InputStream inputStream = DicReader.getInputStream("person/asian_name_freq.data");
            Throwable throwable = null;
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                map = (Map)objectInputStream.readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.warn("IO\u5f02\u5e38", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("\u627e\u4e0d\u5230\u7c7b", (Throwable)e);
        }
        return map;
    }

    public static void initBigramTables() {
        try {
            BufferedReader reader = IOUtil.getReader((InputStream)DicReader.getInputStream("bigramdict.dic"), (String)"UTF-8");
            Throwable throwable = null;
            try {
                String temp = null;
                String[] strs = null;
                int freq = 0;
                while ((temp = reader.readLine()) != null) {
                    if (StringUtil.isBlank((CharSequence)temp)) continue;
                    strs = temp.split("\t");
                    freq = Integer.parseInt(strs[1]);
                    strs = strs[0].split("@");
                    AnsjItem fromItem = DATDictionary.getItem(strs[0]);
                    AnsjItem toItem = DATDictionary.getItem(strs[1]);
                    if (fromItem == AnsjItem.NULL && strs[0].contains("#")) {
                        fromItem = AnsjItem.BEGIN;
                    }
                    if (toItem == AnsjItem.NULL && strs[1].contains("#")) {
                        toItem = AnsjItem.END;
                    }
                    if (fromItem == AnsjItem.NULL || toItem == AnsjItem.NULL) continue;
                    if (fromItem.bigramEntryMap == null) {
                        fromItem.bigramEntryMap = new HashMap<Integer, Integer>();
                    }
                    fromItem.bigramEntryMap.put(toItem.getIndex(), freq);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("\u6570\u5b57\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("IO\u5f02\u5e38", (Throwable)e);
        }
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz);
    }

    static {
        File find;
        LOG = LogFactory.getLog(MyStaticValue.class);
        isNameRecognition = true;
        isNumRecognition = true;
        isQuantifierRecognition = true;
        isRealName = false;
        isSkipUserDefine = false;
        ENV = new HashMap<String, String>();
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("ansj_library");
        }
        catch (Exception e) {
            try {
                find = FileFinder.find((String)"ansj_library.properties", (int)1);
                if (find != null && find.isFile()) {
                    rb = new PropertyResourceBundle(IOUtil.getReader((String)find.getAbsolutePath(), (String)System.getProperty("file.encoding")));
                    LOG.info("load ansj_library not find in classPath ! i find it in " + find.getAbsolutePath() + " make sure it is your config!");
                }
            }
            catch (Exception e1) {
                LOG.warn("not find ansj_library.properties. and err {} i think it is a bug!");
            }
        }
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle("library");
            }
            catch (Exception e) {
                try {
                    find = FileFinder.find((String)"library.properties", (int)2);
                    if (find != null && find.isFile()) {
                        rb = new PropertyResourceBundle(IOUtil.getReader((String)find.getAbsolutePath(), (String)System.getProperty("file.encoding")));
                        LOG.info("load library not find in classPath ! i find it in " + find.getAbsolutePath() + " make sure it is your config!");
                    }
                }
                catch (Exception e1) {
                    LOG.warn("not find library.properties. and err {} i think it is a bug!", (Throwable)e1);
                }
            }
        }
        if (rb == null) {
            LOG.warn("not find library.properties in classpath use it by default !");
        } else {
            for (String key : rb.keySet()) {
                ENV.put(key, rb.getString(key));
                try {
                    String value = rb.getString(key);
                    if (value.startsWith("jdbc:")) {
                        value = Jdbc2Stream.encryption(value);
                    }
                    LOG.info("init " + key + " to env value is : " + value);
                    Field field = MyStaticValue.class.getField(key);
                    field.set(null, ObjConver.conversion((Object)rb.getString(key), field.getType()));
                }
                catch (Exception exception) {}
            }
        }
    }
}

