/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.arrimpl;

import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.DicLibrary;
import org.ansj.recognition.TermArrRecognition;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class UserDefineRecognition
implements TermArrRecognition {
    public static final Log logger = LogFactory.getLog(UserDefineRecognition.class);
    private Term[] terms = null;
    private Forest[] forests = new Forest[]{DicLibrary.get()};
    private int offe = -1;
    private int endOffe = -1;
    private int tempFreq = 50;
    private String tempNature;
    private SmartForest<String[]> branch = null;
    private SmartForest<String[]> forest = null;
    private TermUtil.InsertTermType type = TermUtil.InsertTermType.SKIP;

    public UserDefineRecognition(TermUtil.InsertTermType type, Forest ... forests) {
        this.type = type;
        if (forests != null && forests.length > 0) {
            this.forests = forests;
        }
    }

    @Override
    public void recognition(Term[] terms) {
        this.terms = terms;
        for (Forest forest : this.forests) {
            if (forest == null) continue;
            this.reset();
            this.forest = forest;
            this.branch = forest;
            int length = terms.length - 1;
            boolean flag = true;
            for (int i = 0; i < length; ++i) {
                if (terms[i] == null) continue;
                flag = this.branch != forest;
                this.branch = this.termStatus(this.branch, terms[i]);
                if (this.branch == null) {
                    if (this.offe != -1) {
                        i = this.offe;
                    }
                    this.reset();
                    continue;
                }
                if (this.branch.getStatus() == 3) {
                    this.endOffe = i;
                    this.tempNature = ((String[])this.branch.getParam())[0];
                    this.tempFreq = this.getInt(((String[])this.branch.getParam())[1], 50);
                    if (this.offe != -1 && this.offe < this.endOffe) {
                        i = this.offe;
                        this.makeNewTerm();
                        this.reset();
                        continue;
                    }
                    this.reset();
                    continue;
                }
                if (this.branch.getStatus() == 2) {
                    this.endOffe = i;
                    if (this.offe == -1) {
                        this.offe = i;
                        continue;
                    }
                    this.tempNature = ((String[])this.branch.getParam())[0];
                    this.tempFreq = this.getInt(((String[])this.branch.getParam())[1], 50);
                    if (!flag) continue;
                    this.makeNewTerm();
                    continue;
                }
                if (this.branch.getStatus() != 1 || this.offe != -1) continue;
                this.offe = i;
            }
            if (this.offe == -1 || this.offe >= this.endOffe) continue;
            this.makeNewTerm();
        }
    }

    private int getInt(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            logger.warn(str + "\u4e0d\u662f\u4e00\u4e2a\u6570\u5b57", (Throwable)e);
            return def;
        }
    }

    private void makeNewTerm() {
        StringBuilder sb = new StringBuilder();
        for (int j = this.offe; j <= this.endOffe; ++j) {
            if (this.terms[j] == null) continue;
            sb.append(this.terms[j].getName());
        }
        TermNatures termNatures = new TermNatures(new TermNature(this.tempNature, this.tempFreq));
        Term term = new Term(sb.toString(), this.offe, termNatures);
        term.selfScore(-1 * this.tempFreq);
        TermUtil.insertTerm(this.terms, term, this.type);
    }

    private void reset() {
        this.offe = -1;
        this.endOffe = -1;
        this.tempFreq = 50;
        this.tempNature = null;
        this.branch = this.forest;
    }

    private SmartForest<String[]> termStatus(SmartForest<String[]> branch, Term term) {
        String name = term.getName();
        SmartForest sf = branch;
        for (int j = 0; j < name.length(); ++j) {
            if ((sf = sf.get(name.charAt(j))) != null) continue;
            return null;
        }
        return sf;
    }
}

