/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.arrimpl;

import org.ansj.dic.LearnTool;
import org.ansj.domain.Nature;
import org.ansj.domain.NewWord;
import org.ansj.domain.Term;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.domain.SmartForest;

public class NewWordRecognition {
    private Term[] terms = null;
    private double score;
    private StringBuilder sb = new StringBuilder();
    private SmartForest<NewWord> forest = null;
    private SmartForest<NewWord> branch = null;
    private Nature tempNature;
    private Term from;
    private Term to;
    private int offe;

    public NewWordRecognition(LearnTool learn) {
        this.forest = learn.getForest();
        this.branch = learn.getForest();
    }

    public void recognition(Term[] terms) {
        this.terms = terms;
        if (this.branch == null) {
            return;
        }
        int length = terms.length - 1;
        Term term = null;
        for (int i = 0; i < length; ++i) {
            if (terms[i] == null) continue;
            this.from = terms[i].from();
            terms[i].score(0.0);
            terms[i].selfScore(0.0);
            this.branch = this.branch.getBranch(terms[i].getName());
            if (this.branch == null || this.branch.getStatus() == 3) {
                this.reset();
                continue;
            }
            this.offe = i;
            term = terms[i];
            this.sb.append(term.getName());
            if (this.branch.getStatus() == 2) {
                term.selfScore(((NewWord)this.branch.getParam()).getScore());
            }
            boolean flag = true;
            block6: while (flag) {
                term = term.to();
                this.branch = this.branch.getBranch(term.getName());
                if (this.branch == null) break;
                switch (this.branch.getStatus()) {
                    case 1: {
                        this.sb.append(term.getName());
                        continue block6;
                    }
                    case 2: {
                        this.sb.append(term.getName());
                        this.score = ((NewWord)this.branch.getParam()).getScore();
                        this.tempNature = ((NewWord)this.branch.getParam()).getNature();
                        this.to = term.to();
                        this.makeNewTerm();
                        continue block6;
                    }
                    case 3: {
                        this.sb.append(term.getName());
                        this.score = ((NewWord)this.branch.getParam()).getScore();
                        this.tempNature = ((NewWord)this.branch.getParam()).getNature();
                        this.to = term.to();
                        this.makeNewTerm();
                        flag = false;
                        continue block6;
                    }
                }
                System.out.println("\u600e\u4e48\u80fd\u51fa\u73b00\u5462?");
            }
            this.reset();
        }
    }

    private void makeNewTerm() {
        Term term = new Term(this.sb.toString(), this.offe, this.tempNature.natureStr, 1);
        term.selfScore(this.score);
        term.setNature(this.tempNature);
        if (this.sb.length() > 3) {
            term.setSubTerm(TermUtil.getSubTerm(this.from, this.to));
        }
        TermUtil.termLink(this.from, term);
        TermUtil.termLink(term, this.to);
        TermUtil.insertTerm(this.terms, term, TermUtil.InsertTermType.SCORE_ADD_SORT);
        TermUtil.parseNature(term);
    }

    private void reset() {
        this.offe = -1;
        this.tempNature = null;
        this.branch = this.forest;
        this.score = 0.0;
        this.sb = new StringBuilder();
    }
}

