/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.PathToStream;
import org.ansj.domain.KV;
import org.ansj.library.DATDictionary;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.Value;
import org.nlpcn.commons.lang.tire.library.Library;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class DicLibrary {
    private static final Log LOG = LogFactory.getLog();
    public static final String DEFAULT = "dic";
    public static final String DEFAULT_NATURE = "userDefine";
    public static final Integer DEFAULT_FREQ = 1000;
    public static final String DEFAULT_FREQ_STR = "1000";
    private static final Map<String, KV<String, Forest>> DIC = new HashMap<String, KV<String, Forest>>();

    public static void insert(String key, String keyword, String nature, int freq) {
        Forest dic = DicLibrary.get(key);
        String[] paramers = new String[]{nature, String.valueOf(freq)};
        Value value = new Value(keyword, paramers);
        Library.insertWord((Forest)dic, (Value)value);
    }

    public static void insert(String key, String keyword) {
        DicLibrary.insert(key, keyword, DEFAULT_NATURE, DEFAULT_FREQ);
    }

    public static void delete(String key, String word) {
        Forest dic = DicLibrary.get(key);
        if (dic != null) {
            Library.removeWord((Forest)dic, (String)word);
        }
    }

    public static void clear(String key) {
        DicLibrary.get(key).clear();
    }

    public static Forest get() {
        if (!DIC.containsKey(DEFAULT)) {
            return null;
        }
        return DicLibrary.get(DEFAULT);
    }

    public static Forest get(String key) {
        KV<String, Forest> kv = DIC.get(key);
        if (kv == null) {
            if (MyStaticValue.ENV.containsKey(key)) {
                DicLibrary.putIfAbsent(key, MyStaticValue.ENV.get(key));
                return DicLibrary.get(key);
            }
            LOG.warn("dic " + key + " not found in config ");
            return null;
        }
        Forest forest = kv.getV();
        if (forest == null) {
            forest = DicLibrary.init(key, kv);
        }
        return forest;
    }

    public static Forest[] gets(String ... keys) {
        Forest[] forests = new Forest[keys.length];
        for (int i = 0; i < forests.length; ++i) {
            forests[i] = DicLibrary.get(keys[i]);
        }
        return forests;
    }

    public static Forest[] gets(Collection<String> keys) {
        return DicLibrary.gets(keys.toArray(new String[keys.size()]));
    }

    private static synchronized Forest init(String key, KV<String, Forest> kv) {
        Forest forest = kv.getV();
        if (forest != null) {
            return forest;
        }
        try {
            forest = new Forest();
            LOG.debug("begin init dic !");
            long start = System.currentTimeMillis();
            String temp = null;
            String[] strs = null;
            Value value = null;
            BufferedReader br = IOUtil.getReader((InputStream)PathToStream.stream(kv.getK()), (String)"UTF-8");
            Throwable throwable = null;
            try {
                while ((temp = br.readLine()) != null) {
                    if (!StringUtil.isNotBlank((CharSequence)temp)) continue;
                    temp = StringUtil.trim((String)temp);
                    strs = temp.split("\t");
                    strs[0] = strs[0].toLowerCase();
                    if (MyStaticValue.isSkipUserDefine && DATDictionary.getId(strs[0]) > 0) continue;
                    value = strs.length != 3 ? new Value(strs[0], new String[]{DEFAULT_NATURE, DEFAULT_FREQ_STR}) : new Value(strs[0], new String[]{strs[1], strs[2]});
                    Library.insertWord((Forest)forest, (Value)value);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
            LOG.info("load dic use time:" + (System.currentTimeMillis() - start) + " path is : " + kv.getK());
            kv.setV(forest);
            return forest;
        }
        catch (Exception e) {
            LOG.error("Init ambiguity library error :" + e.getMessage() + ", path: " + kv.getK());
            DIC.remove(key);
            return null;
        }
    }

    public static void put(String key, String path, Forest forest) {
        DIC.put(key, KV.with(path, forest));
    }

    public static void putIfAbsent(String key, String path) {
        if (!DIC.containsKey(key)) {
            DIC.put(key, KV.with(path, null));
        }
    }

    public static void put(String key, String path) {
        DicLibrary.put(key, path, null);
    }

    public static synchronized Forest putIfAbsent(String key, String path, Forest forest) {
        KV<String, Forest> kv = DIC.get(key);
        if (kv != null && kv.getV() != null) {
            return kv.getV();
        }
        DicLibrary.put(key, path, forest);
        return forest;
    }

    public static KV<String, Forest> remove(String key) {
        return DIC.remove(key);
    }

    public static Set<String> keys() {
        return DIC.keySet();
    }

    public static void reload(String key) {
        KV<String, Forest> kv = DIC.get(key);
        if (kv != null) {
            DIC.get(key).setV(null);
        }
    }

    static {
        for (Map.Entry<String, String> entry : MyStaticValue.ENV.entrySet()) {
            if (!entry.getKey().startsWith(DEFAULT)) continue;
            DicLibrary.put(entry.getKey(), entry.getValue());
        }
        DicLibrary.putIfAbsent(DEFAULT, "library/default.dic");
        Forest forest = DicLibrary.get();
        if (forest == null) {
            DicLibrary.put(DEFAULT, DEFAULT, new Forest());
        }
    }
}

