/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.app.crf.Model;
import org.ansj.app.crf.SplitWord;
import org.ansj.app.crf.model.CRFModel;
import org.ansj.dic.PathToStream;
import org.ansj.domain.KV;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.util.logging.Log;

public class CrfLibrary {
    private static final Log LOG = MyStaticValue.getLog(CrfLibrary.class);
    private static final Map<String, KV<String, SplitWord>> CRF = new HashMap<String, KV<String, SplitWord>>();
    public static final String DEFAULT = "crf";

    public static SplitWord get() {
        return CrfLibrary.get(DEFAULT);
    }

    public static SplitWord get(String key) {
        KV<String, SplitWord> kv = CRF.get(key);
        if (kv == null) {
            if (MyStaticValue.ENV.containsKey(key)) {
                CrfLibrary.putIfAbsent(key, MyStaticValue.ENV.get(key));
                return CrfLibrary.get(key);
            }
            LOG.warn("crf " + key + " not found in config ");
            return null;
        }
        SplitWord sw = kv.getV();
        if (sw == null) {
            sw = CrfLibrary.initCRFModel(kv);
        }
        return sw;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized SplitWord initCRFModel(KV<String, SplitWord> kv) {
        try {
            if (kv.getV() != null) {
                return kv.getV();
            }
            long start = System.currentTimeMillis();
            LOG.debug("begin init crf model!");
            InputStream is = PathToStream.stream(kv.getK());
            Throwable throwable = null;
            try {
                SplitWord crfSplitWord = new SplitWord(Model.load(CRFModel.class, is));
                kv.setV(crfSplitWord);
                LOG.info("load crf use time:" + (System.currentTimeMillis() - start) + " path is : " + kv.getK());
                SplitWord splitWord = crfSplitWord;
                return splitWord;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error(kv + " load err " + e.getMessage());
            return null;
        }
    }

    public static void put(String key, String path) {
        CrfLibrary.put(key, path, null);
    }

    public static void put(String key, String path, SplitWord sw) {
        CRF.put(key, KV.with(path, sw));
    }

    public static KV<String, SplitWord> remove(String key) {
        return CRF.remove(key);
    }

    public static void reload(String key) {
        KV<String, SplitWord> kv = CRF.get(key);
        if (kv != null) {
            CRF.get(key).setV(null);
        }
    }

    public static Set<String> keys() {
        return CRF.keySet();
    }

    public static void putIfAbsent(String key, String path) {
        if (!CRF.containsKey(key)) {
            CRF.put(key, KV.with(path, null));
        }
    }

    static {
        for (Map.Entry<String, String> entry : MyStaticValue.ENV.entrySet()) {
            if (!entry.getKey().startsWith(DEFAULT)) continue;
            CrfLibrary.put(entry.getKey(), entry.getValue());
        }
        CrfLibrary.putIfAbsent(DEFAULT, "jar://crf.model");
    }
}

