/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.tire;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ObjTree<T>
implements Serializable {
    private Map<Object, ObjTree<T>> branches;
    private T obj;
    private int status;

    public void add(T t, Object ... objs) {
        ObjTree<T> objTree = this;
        int len = objs.length;
        for (int i = 0; i < len; ++i) {
            objTree = objTree.getOrCreateObjTree(objs[i]);
            if (objTree.status == 3) {
                objTree.status = 2;
                continue;
            }
            if (objTree.status != 0) continue;
            objTree.status = 1;
        }
        objTree.setObj(t);
        if (objTree.status == 1) {
            objTree.status = 2;
        } else if (objTree.status == 0) {
            objTree.status = 3;
        }
    }

    public T get(Object ... objs) {
        ObjTree<T> objTree = this.getObjTree(objs);
        if (objTree == null) {
            return null;
        }
        return objTree.getObj();
    }

    public ObjTree<T> getObjTree(Object ... objs) {
        ObjTree objTree = this;
        for (int i = 0; i < objs.length; ++i) {
            if ((objTree = objTree.getObjTree(objs[i])) != null) continue;
            return null;
        }
        return objTree;
    }

    public boolean contains(Object ... objs) {
        ObjTree objTree = this;
        for (int i = 0; i < objs.length; ++i) {
            if ((objTree = objTree.getObjTree(objs[i])) != null) continue;
            return false;
        }
        return objTree.status > 1;
    }

    private ObjTree getObjTree(Object obj) {
        if (this.branches == null) {
            return null;
        }
        return this.branches.get(obj);
    }

    private ObjTree<T> getOrCreateObjTree(Object obj) {
        ObjTree<T> objTree;
        if (this.branches == null) {
            this.branches = new HashMap<Object, ObjTree<T>>();
        }
        if ((objTree = this.branches.get(obj)) == null) {
            objTree = new ObjTree<T>();
            this.branches.put(obj, objTree);
        }
        return objTree;
    }

    public Map<Object, ObjTree<T>> getBranches() {
        return this.branches;
    }

    public int getStatus() {
        return this.status;
    }

    public T getObj() {
        return this.obj;
    }

    public void setObj(T obj) {
        this.obj = obj;
    }
}

