/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.LoggerProvider;
import org.slf4j.LoggerFactory;

final class LoggerProviderSLF4J
implements LoggerProvider {
    public static final LoggerProvider INSTANCE = new LoggerProviderSLF4J();
    private static volatile Logger sourceLogger = null;

    private LoggerProviderSLF4J() {
    }

    @Override
    public Logger getLogger(String name) {
        return new SLF4JLogger(LoggerFactory.getLogger((String)name));
    }

    @Override
    public Logger getSourceLogger() {
        if (sourceLogger == null) {
            sourceLogger = this.getLogger("net.htmlparser.jericho");
        }
        return sourceLogger;
    }

    private static class SLF4JLogger
    implements Logger {
        private final org.slf4j.Logger slf4jLogger;

        public SLF4JLogger(org.slf4j.Logger slf4jLogger) {
            this.slf4jLogger = slf4jLogger;
        }

        @Override
        public void error(String message) {
            this.slf4jLogger.error(message);
        }

        @Override
        public void warn(String message) {
            this.slf4jLogger.warn(message);
        }

        @Override
        public void info(String message) {
            this.slf4jLogger.info(message);
        }

        @Override
        public void debug(String message) {
            this.slf4jLogger.debug(message);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.slf4jLogger.isErrorEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.slf4jLogger.isWarnEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.slf4jLogger.isInfoEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.slf4jLogger.isDebugEnabled();
        }
    }
}

